/**
 * Этот мидлвар проверяет что если у пользователя нет организации,
 * но паспорт считает его коннектным, то мы кидаем его на страницу дорегистрации
 * Также если внешний пользователь пришел на страницу дорегистрации, редириктим его на корневой роут
 */

const { URL } = require('url');
const responseContext = require('../lib/responseContext');
const template = require('../lib/template');
const logger = require('../lib/logger');

module.exports = function(req, res, next) {
    const config = req.config;
    const org = responseContext.getCurrentOrganization(req);

    const host = responseContext.getHost(req);
    const isInternal = responseContext.isInternal(req);
    const isSetup = responseContext.isSetup(req);
    const isHTMLRequest = req.accepts(['html']) === 'html';

    let redirectUrl;

    const hasNoValidOrganization =
        !responseContext.hasOrganizations(req) ||
        !org || !org.name || !org.language;

    if (isHTMLRequest && !isSetup && isInternal && hasNoValidOrganization) {
        redirectUrl = template.build(config.org.setup, { host, query: '' });
        logger.info('Redirect internal user with no valid organization to setup page', req, { redirectUrl });

        return res.redirect(redirectUrl);
    }

    // Внешних пользователей, которые пришли на страницу дорегистрации, редириктим на корневой роут
    if (!isInternal && isSetup) {
        redirectUrl = new URL(req.query.retpath || '/', `https://${host}`).href;
        logger.info('Redirect external user from setup page', req, { redirectUrl });

        return res.redirect(redirectUrl);
    }

    if (org && org.is_blocked) {
        redirectUrl = template.build(config.ui.forbidden, {
            host,
            source: 'connect',
            reason: 'blocked-org',
            retpath: encodeURIComponent(responseContext.getUrl(req, req.originalUrl)),
        });

        return res.redirect(redirectUrl);
    }

    next();
};
