const _ = require('lodash');
const template = require('../lib/template');
const responseContext = require('../lib/responseContext');

/**
 * Карма спамера в паспорте
 * Документация https://doc.yandex-team.ru/Passport/AuthDevGuide/concepts/accounts-attributes.xml#accounts-attributes__karma
 * Возможные значения кармы:
 * 0 - карма обычного пользователя
 * 85 - подозрение(скорее всего) на спамера
 * 100 - точно спамер
 */
const SPAM_USER_KARMA = 100;
const SUSPECTED_SPAM_USER_KARMA = 85;

module.exports = function(req, res, next) {
    const { karma } = req.context;

    if (karma === SPAM_USER_KARMA) {
        const currentUrl = `https://${responseContext.getHost(req)}${req.originalUrl}`;

        return res.redirect(template.build(_.get(req.config, 'passport.session.approveUser'), {
            retpath: encodeURIComponent(currentUrl),
        }));
    }

    if (karma === SUSPECTED_SPAM_USER_KARMA) {
        req.context.isCaptchaRequired = true;
    }

    next();
};
