const querystring = require('querystring');
const _ = require('lodash');
const org = require('../routes/api/organization');
const getUrl = require('../lib/getUrl');
const responseContext = require('../lib/responseContext');
const setYCookie = require('../lib/setYCookie');

// общее описание: https://st.yandex-team.ru/DIR-7060
// Y cookie: https://wiki.yandex-team.ru/cookies/y/

function fetchAvailableOrganizations(req) {
    if (req.query.mode === 'portal') {
        req.query = {
            fields: 'id',
        };

        return org.readList(req)
            .then(() =>
                // из Директории
                _.get(req.context, 'organizations', [])
                    .map(item => String(item.id))
            );
    }

    return Promise.resolve(
        // из атрибута 1017 в Паспорте
        _.get(req.context, 'session.org_id', '').split(',').filter(Boolean)
    );
}

function toForbidden(res, options) {
    const query = querystring.stringify(Object.assign({ origin: 'context' }, options));

    res.redirect(getUrl(`/forbidden?${query}`));
}

module.exports = (req, res, next) => {
    let { retpath, tld, sk, org_id: nextOrgId, silent } = req.query;

    if (silent === '0') {
        return next('route');
    }

    if (!tld) {
        tld = _.get(req.config, 'app.tld');
    }

    // если retpath относительный, делаем его абсолютным
    if (retpath && !/^(https?:)?\/\//.test(retpath)) {
        retpath = responseContext.getUrl(req, retpath);
    }

    return fetchAvailableOrganizations(req)
        .then(availableOrgIds => {
            if (!availableOrgIds.length) {
                return toForbidden(res, { reason: 'no_orgs', retpath });
            }

            if (!nextOrgId || !availableOrgIds.includes(nextOrgId)) {
                nextOrgId = availableOrgIds[0];
            }

            setYCookie(req, res, {
                key: 'org_id',
                value: nextOrgId,
                sk,
                retpath,
            });
        })
        .catch(next);
};
