/**
 * Проверяем воркспейсность пользователя
 * Если пользователь внешний(без аттрибоута 1011) и у него нет организаций,
 * то редиректим на страничку /forbidden
 */

const logger = require('../lib/logger');
const responseFilter = require('../lib/responseFilter');
const responseContext = require('../lib/responseContext');

module.exports = function(req, res, next) {
    responseFilter.preprocessMixedResponse(req.context);

    const isAllowed = responseContext.isAllowed(req);

    let originalUrl;
    let redirectUrl;

    // не воркспейсных пользователей(без аттрибоута 1011)
    // у которых в списке нет ни одной оргинизации(не внешние админы) редиректим на страницу /forbidden
    if (!isAllowed) {
        originalUrl = responseContext.getUrl(req, req.originalUrl);
        redirectUrl = responseContext.getUrl(req,
            `/forbidden?source=connect&reason=external-user&retpath=${encodeURIComponent(originalUrl)}`);

        logger.info(`Forbidden ${originalUrl}`, req, req.context);
        res.redirect(redirectUrl);

        return;
    }

    next();
};
