const expressCaptcha = require('@yandex-int/express-captcha');
const _ = require('lodash');
const i18n = require('../lib/i18n');

module.exports = [

    function(req, res, next) {
        expressCaptcha.generate(_.assign({ vtype: i18n.getLocale(req) }, req.config.captchaOptions))(req, res, next);
    },

    function(req, res, next) {
        if (req.captcha === null) {
            next({
                errorCode: 500,
                code: 'captcha_generate_error',
            });

            return;
        }

        res.json({ captcha: req.captcha });
    },
];
