/**
 * Мидлваря нужна для того, чтоб не отвечать глобальной 500 при ошибках директории
 */

const _ = require('lodash');
const logger = require('../lib/logger');
const sendApiResponse = require('../lib/sendApiResponse');

const DEFAULT_ERROR_CODE = 500;

module.exports = function(err, req, res, next) {
    if (res.headersSent) {
        return next(err);
    }

    if (err.errorCode || err.code) {
        logger.error(`HandleApiError: ${_.get(err, 'message')}`, req, { stack: _.get(err, 'stack') });

        // Если получили объект с ошибкой, то оставляем только код
        // чтобы не прокидывать лишнее
        if (err instanceof Error) {
            err = {
                code: err.code,
            };
        }

        sendApiResponse(req, res, err, err.errorCode || DEFAULT_ERROR_CODE);

        return;
    }

    if (!err.statusCode) {
        next(err); // Если ошибка другого рода, валим в следующий обработчик ошибок

        return;
    }

    try {
        err.body = typeof err.body === 'object' ? err.body : JSON.parse(err.body);
    } catch (e) {
        err.body = {};
    }

    sendApiResponse(req, res, {
        originalError: { body: err.body },
        status: err.statusCode,
        message: err.body.message,
        code: _.get(err, 'body.code') || _.get(err, 'body.error'),
        // `url` используется для вычисления неймспейса кода ошибки
        url: req.originalUrl,
        source: 'directory',
    }, err.statusCode);
};
