/**
 * Обработчик брошенных через next http-ошибок
 * Если ошибка не число, пробрасывает её дальше
 */

const renderIndex = require('../layouts/index');

module.exports = function(err, req, res, next) {
    if (res.headersSent) {
        return next(err);
    }

    const code = err || 500;

    if (typeof err !== 'number') {
        next(err);

        return;
    }

    req.context.error = { code };

    renderIndex(req, res.status(code), next);
};
