/**
 * Обработка мобильных и устаревших браузеров
 */

const _ = require('lodash');
const parser = require('ua-parser-js');
const i18n = require('../lib/i18n');
const responseContext = require('../lib/responseContext');

const MOBILE_OS = ['iOS', 'Android', 'Windows [Phone/Mobile]'];

module.exports = (req, res, next) => {
    const config = req.config;
    const ua = parser(req.headers['user-agent']);
    let dictionary;

    const isUnsupported = _.get(ua, 'browser.name') === 'IE' &&
        Number(_.get(ua, 'browser.major')) < 11;

    const isMobile = MOBILE_OS.indexOf(_.get(ua, 'os.name')) !== -1;
    const isMobileWarningVisited = req.cookies.mobile_warning_visited === 'yes';
    const shouldSkipMuseum = responseContext.isSetup(req);

    const shouldRenderMuseum = isUnsupported ||
        (isMobile && !isMobileWarningVisited && !shouldSkipMuseum);

    if (shouldRenderMuseum) {
        dictionary = i18n.getDictionary(req);

        res.render('museum', {
            title: _.get(dictionary, 'common.full_main_title', 'Yandex.Connect'),
            i18n: _.pick(dictionary, ['common', 'museum']),
            locale: i18n.getLocale(req),
            isMobile,
            staticPrefix: config.app.assets,
        });

        return;
    }

    next();
};
