const _ = require('lodash');
const responseContext = require('../lib/responseContext');
const permissionsApi = require('../routes/api/permissions');

module.exports = function(req, res, next) {
    if (_.get(req, 'context.permissions') || !responseContext.hasOrganizations(req)) {
        return next();
    }

    return permissionsApi.readGlobal(req, res, next);
};
