/**
 * Мидлваря, отвечающая за выставление общих http-заголовков для директории
 */

const _ = require('lodash');
const i18n = require('../lib/i18n');

module.exports = function(req, res, next) {
    req.context = req.context || {};
    req.context.headers = req.context.headers || {};

    req.context.headers['Accept-Language'] = i18n.getLocale(req);

    if (!_.get(req.context, 'auth.errorCode')) {
        req.context.headers = _.extend(req.context.headers, req.context.auth);
    }

    next();
};
