const _ = require('lodash');

function setRequestTime(req, res, next) {
    if (req.context && req.context.timing) {
        _.extend(req.context.timing, {
            url: req.get('host') + req.originalUrl,
            duration: Date.now() - req.context.timing.timestamp,
        });
    }
    next();
}

module.exports = setRequestTime;
