/**
 * Мидлваря, отвечающая за выставление общих http-заголовков для директории
 */

module.exports = function(req, res, next) {
    req.context = req.context || {};
    req.context.headers = req.context.headers || {};

    const xOrgId = req.get('x-org-id');

    if (xOrgId) {
        req.context.headers['x-org-id'] = xOrgId;
    }

    const xDebug = req.get('x-debug') || (req.query ? req.query.debug : null);

    if (xDebug) {
        req.context.headers['x-debug'] = xDebug;
    }

    const isFirstLoad = req.get('x-first-visit');

    if (isFirstLoad) {
        req.context.headers['x-database'] = 'master';
    }

    next();
};
