const _ = require('lodash');
const template = require('../lib/template');
const logger = require('../lib/logger');
const responseContext = require('../lib/responseContext');

module.exports = function(req, res, next) {
    if (responseContext.isLightAccount(req) || responseContext.isSocialAccount(req)) {
        const upgradeUrl = template.build(_.get(req.config, 'passport.session.upgradeUser'), {
            retpath: encodeURIComponent(`https://${responseContext.getHost(req)}${req.originalUrl}`),
            tld: _.get(req.config, 'app.tld', 'ru'),
        });

        logger.info(`Redirect to upgrade url ${upgradeUrl}`, req);

        return res.redirect(upgradeUrl);
    }

    next();
};
