const responseContext = require('../lib/responseContext');

module.exports = (req, res, next) => {
    if (!responseContext.hasOrganizations(req)) {
        return next();
    }

    Promise.all([
        require('../routes/api/services').readMenu(req),
        require('../routes/api/services').readAll(req),
        require('../routes/api/org/features').read(req),
    ])
        .then(() => next())
        .catch(() => next());
};
