/**
 * Мидлваря, отвечающая за выставление заголовка x-request-id
 */

function getRandomString(length) {
    let s = '';

    while (s.length < length) {
        s += Math.random().toString(36).slice(2);
    }

    return s.slice(-length);
}

module.exports = function(req, res, next) {
    req.context = req.context || {};
    req.context.headers = req.context.headers || {};

    req.context.requestId = req.get('x-request-id') || getRandomString(16);
    req.context.headers['x-request-id'] = req.context.requestId;

    // добавляем x-request-id в заголовки ответа
    res.setHeader('x-request-id', req.context.headers['x-request-id']);

    next();
};
