const _ = require('lodash');
const organization = require('./organization');
const permissions = require('./permissions');

function read(req, res, next) {
    const requests = [];

    const organizationRequest = organization.read(req);

    requests.push(organizationRequest);

    const permissionsRequest = permissions.read(req);

    requests.push(permissionsRequest);

    return Promise.all(requests)
        .then(nextReq => next ? next() : nextReq)
        .catch(next);
}

module.exports = _.extend({}, organization, { read });
