const _ = require('lodash');
const sendHandledRequest = require('../../../lib/sendHandledRequest');
const responseContext = require('../../../lib/responseContext');

function read(req, res, next) {
    const orgId = responseContext.getCurrentOrganizationId(req);

    if (!orgId) {
        return next ? next() : req;
    }

    sendHandledRequest({
        method: 'get',
        url: [req.config.api.directory, 'v8', 'organizations', orgId, 'features'],
        source: req,
        label: 'read_org_features',
    })
        .then(response => {
            req.context.features = _.merge(req.context.features, response);

            return next ? next() : req;
        })
        .catch(next);
}

module.exports = {
    read,
};
