const sendHandledRequest = require('../../../lib/sendHandledRequest');

function change(req, res, next) {
    const orgId = req.query.org_id || req.get('x-org-id');

    return sendHandledRequest({
        method: 'post',
        url: [
            req.config.api.directory, 'v8', 'organizations',
            { value: orgId, type: 'number' }, 'change-owner',
        ],
        source: req,
        label: 'change_organization_owner',
    })
        .then(response => {
            req.context.owner_change = response;

            return next ? next() : req;
        })
        .catch(next);
}

function getChangeStatus(req, res, next) {
    const orgId = req.query.org_id || req.get('x-org-id');

    return sendHandledRequest({
        method: 'get',
        url: [
            req.config.api.directory, 'v8', 'organizations',
            { value: orgId, type: 'number' }, 'change-owner',
        ],
        query: {
            task_id: req.query.task_id,
        },
        source: req,
        label: 'read_organization_owner_change_status',
    })
        .then(response => {
            req.context.owner_change = response;

            return next ? next() : req;
        })
        .catch(next);
}

module.exports = {
    change, getChangeStatus,
};
