const config = require('../../../config');
const sendHandledRequest = require('../../../lib/sendHandledRequest');

const API_ROOT = config.api.directory;

function setOrgLogoUrl(req, res, next) {
    const orgId = req.query.id || req.get('x-org-id');

    return sendHandledRequest({
        method: 'post',
        url: [
            API_ROOT, 'organizations', { value: orgId, type: 'number' },
            'change-logo',
        ],
        source: req,
        label: 'set_organization_logo',
    })
        .then(() => next ? next() : req)
        .catch(next);
}

module.exports = setOrgLogoUrl;
