const _ = require('lodash');
const sendHandledRequest = require('../../../lib/sendHandledRequest');

function getCurrentOwner(req, res, next) {
    return sendHandledRequest({
        method: 'get',
        url: [
            req.config.api.directory,
            'restore',
            'current-owner',
            encodeURIComponent(req.query.domain),
        ],
        source: req,
        label: 'read_current_owner',
    })
        .then(data => {
            _.set(req.context, ['restore', 'current_owner'], data);

            return next ? next() : data;
        })
        .catch(next);
}

function getCheckStatus(req, res, next) {
    return sendHandledRequest({
        method: 'get',
        url: [
            req.config.api.directory,
            'restore',
            { value: req.query.restore_id, type: 'code' },
        ],
        source: req,
        label: 'read_restore_status',
    })
        .then(data => {
            _.set(req.context, ['restore', 'checks', req.query.restore_id], data);

            return next ? next() : data;
        })
        .catch(next);
}

function getActiveChecks(req, res, next) {
    if (req.query.restore_id) {
        return getCheckStatus(req, res)
            .then(data => {
                _.set(req.context, ['restore', 'current_check'], data);

                return next ? next() : data;
            })
            .catch(next);
    }

    return sendHandledRequest({
        method: 'get',
        url: [req.config.api.directory, 'restore'],
        source: req,
        label: 'read_active_restores',
    })
        .then(data => {
            _.set(req.context, ['restore', 'active_checks'], data);

            return next ? next() : data;
        })
        .catch(next);
}

function start(req, res, next) {
    return sendHandledRequest({
        method: 'post',
        url: [req.config.api.directory, 'restore'],
        source: req,
        label: 'start_restore',
    })
        .then(data => {
            _.set(req.context, ['restore', 'current_check'], data);

            return next ? next() : data;
        })
        .catch(next);
}

function getOwnershipStatus(req, res, next) {
    return sendHandledRequest({
        method: 'get',
        url: [
            req.config.api.directory,
            'restore',
            { value: req.query.restore_id, type: 'code' },
            'ownership',
        ],
        source: req,
        label: 'read_restore_ownership',
    })
        .then(data => {
            _.set(req.context, ['restore', 'ownership'], data);

            return next ? next() : data;
        })
        .catch(next);
}

function checkOwnership(req, res, next) {
    return sendHandledRequest({
        method: 'post',
        url: [
            req.config.api.directory,
            'restore',
            { value: req.query.restore_id, type: 'code' },
            'ownership',
            'verify',
        ],
        source: req,
        label: 'restore_domain_ownership',
    })
        .then(data => {
            _.set(req.context, ['restore', 'ownership'], data);

            return next ? next() : data;
        })
        .catch(next);
}

module.exports = {
    getCurrentOwner,
    getActiveChecks,
    start,
    getOwnershipStatus,
    checkOwnership,
};
