const sendHandledRequest = require('../../lib/sendHandledRequest');

function read(req, res, next) {
    return sendHandledRequest({
        method: 'get',
        url: [req.config.api.directory, 'suggest'],
        options: {
            headers: req.context.headers,
            qs: req.query,
            timeout: 2000,
        },
        source: req,
        label: 'read_suggest',
    })
        .then(suggest => {
            req.context.suggest = suggest;

            return next ? next() : req;
        })
        .catch(next);
}

module.exports = { read };
