const config = require('../../config');
const sendHandledRequest = require('../../lib/sendHandledRequest');

const API_ROOT = config.api.directory;

function setUserAvatarUrl(req, res, next) {
    return sendHandledRequest({
        method: 'post',
        url: [
            API_ROOT, 'users', { value: req.query.id, type: 'number' },
            'change-avatar',
        ],
        source: req,
        label: 'set_user_avatar',
    })
        .then(() => next ? next() : req)
        .catch(next);
}

module.exports = setUserAvatarUrl;
