const express = require('express');

module.exports = () => {
    var router = express.Router(); // eslint-disable-line

    const setHeaders = require('../../middlewares/setHeaders');
    const setServiceHeaders = require('../../middlewares/setServiceHeaders');
    const setRequestTime = require('../../middlewares/setRequestTime');
    const handleApiErrors = require('../../middlewares/handleApiErrors');
    const send = require('../../middlewares/send');

    const ping = require('./ping');
    const log = require('./log');
    const secretKey = require('./secretKey');

    const owner = require('../api/org/owner');

    router.use(setHeaders);
    router.use(setServiceHeaders);

    router.route('/ping').get(ping);
    router.route('/log').get(log);

    router.route('/sk').get(secretKey);

    router.route('/org/change-owner/status')
        .get(owner.getChangeStatus);

    router.use(handleApiErrors);
    router.use(setRequestTime);
    router.use(send);

    return router;
};
