const logger = require('../../lib/logger');

function log(req, res, next) {
    const message = req.query.message;
    const options = req.query.options;

    if (!message) {
        logger.warn('Malformed log message', req);
    } else if (!options) {
        logger.info(message, req);
    } else {
        try {
            logger.info(message, req, JSON.parse(options));
        } catch (e) {
            logger.info(message, req, { _options: options });
        }
    }

    next();
}

module.exports = log;
