const _ = require('lodash');
const md5 = require('md5');
const msPerDay = 86400000; //

module.exports = (req, res, next) => {
    const uid = _.get(req, 'context.auth.x-uid');
    const days = Math.floor(Date.now() / msPerDay);

    // https://wiki.yandex-team.ru/AlekseyPonomarev/secret-key/#kljuchdljaavtorizovannyxpolzovatelejj
    req.context.sk = `u${md5(`${uid}::${days}`)}`;

    next();
};
