const getUrl = require('../lib2/getUrl');

// @see DIR-8938 #5e96b1c8aaa48b01551683cc
function getYCookieRetpath(req) {
    return (req.query.reason === 'unavailable' && req.query.retpath) || getUrl(req);
}

module.exports = () => [
    require('@yandex-int/express-http-uatraits')(),
    require('@yandex-int/express-yandexuid')(),
    require('../middleware2/htmlCsp')(),
    require('../middleware2/unsupportedBrowser')(),
    require('../middleware2/tvm')(),
    require('../middleware2/blackbox')(),
    require('../middleware2/pageViewAuth')(),
    require('@yandex-int/express-secretkey')(),
    require('../middleware2/karma')(),
    require('../middleware2/accountUpgrade')(),
    require('../middleware2/orgs')(),
    require('../middleware2/orgId')(),
    require('../middleware2/orgIdCookie')(getYCookieRetpath),
    require('../middleware2/orgInfo')(),
    require('../middleware2/blackboxPatch')(),
    require('../middleware2/userInfo')(),
    require('../middleware2/admin')(),
    require('../middleware2/legacyAdapter')(),
    require('../layouts/forbidden'),
];
