const redirect = require('../middleware2/redirect');
// const pddRedirect = redirect('https://pdd.yandex.${tld}');
const portalRedirect = redirect('/portal/home');
const mail360Redirect = redirect('https://business.yandex.${tld}/mail360', {
    utm_source: 'connect_promo',
});

module.exports = () => [
    require('@yandex-int/express-http-uatraits')(),
    require('@yandex-int/express-yandexuid')(),
    require('../middleware2/redirect360')(),
    require('../middleware2/htmlCsp')(),
    require('../middleware2/unsupportedBrowser')(),
    require('../middleware2/tvm')(),
    require('../middleware2/blackbox')(),
    (req, res, next) => { // DIR-10135
        const { blackbox } = req;

        // если урл начинается не с /portal и отсутствует авторизация – редиректим в почту
        if (!req.path.startsWith('/portal') && (!blackbox || !['VALID', 'NEED_RESET'].includes(blackbox.status))) {
            // eslint-disable-next-line no-console
            console.log('Redirect to pdd [noauth]', {
                requestId: req.ctx.requestId,
                uid: blackbox && blackbox.uid,
                bbStatus: blackbox && blackbox.status,
                originalUrl: req.originalUrl,
            });

            return mail360Redirect(req, res);
        }

        return next();
    },
    require('../middleware2/pageViewAuth')(),
    require('@yandex-int/express-secretkey')(),
    require('../middleware2/karma')(),
    require('../middleware2/accountUpgrade')(),
    require('../middleware2/orgs')(),
    (req, res, next) => { // DIR-10135
        const { orgs, requestId } = req.ctx;

        if (req.path.startsWith('/portal/restore')) {
            return next();
        }

        if (!req.path.startsWith('/portal')) {
            // если урл начинается не с /portal и нет организаций – редиректим в почту
            if (!orgs || !orgs.length) {
                // eslint-disable-next-line no-console
                console.log('Redirect to pdd [noorgs]', {
                    orgs,
                    requestId,
                    uid: req.blackbox && req.blackbox.uid,
                    originalUrl: req.originalUrl,
                });

                return mail360Redirect(req, res);
            }

            // если урл начинается не с /portal но есть организации – редиректим в портал
            return portalRedirect(req, res);
        }

        return next();
    },
    require('../middleware2/orgId')(),
    require('../middleware2/orgIdCookie')(),
    require('../middleware2/orgInfo')(),
    require('../middleware2/features')(),
    require('../middleware2/withValidOrg')(),
    require('../middleware2/blackboxPatch')(),
    require('../middleware2/userInfo')(),
    require('../middleware2/services')(),
    require('../middleware2/permissions')(),
    require('../middleware2/orgSettings')(),
    require('../middleware2/userSettings')(),
    require('../middleware2/headerSettings')(),
    require('../middleware2/withEnabledService')(),
    require('../middleware2/legacyAdapter')(),
    require('../layouts/index'),
];
