const _pick = require('lodash/pick');

module.exports = () => [
    require('../middleware2/exceptEnvs')(['production']),
    require('../middleware2/tvm')(),
    require('../middleware2/blackbox')(),
    require('../middleware2/legacyAuthAdapter')(),
    (req, res) => {
        res.json(_pick(req.context, [
            'auth',
            'tvm_tickets',
            'state',
            'session',
            'sessions',
            'karma',
        ]));
    },
];
