(function() {
    const meta = document.querySelector('meta[http-equiv="refresh"]');
    const refreshOptions = meta ? (meta.getAttribute('content') || '').split(/;\s*url=/) : [];

    const timer = document.getElementById('refresh-timer');
    let t0 = parseInt(refreshOptions[0], 10);
    let clock;

    if (t0 !== null && !isNaN(t0)) {
        clock = setInterval(() => {
            if (--t0 > 0) {
                timer.innerHTML = t0;
            } else {
                clearInterval(clock);
            }
        }, 1000);
    }

    const refreshButton = document.getElementById('refresh-button');

    if (refreshButton) {
        refreshButton.addEventListener('click', () => {
            if (refreshOptions[1]) {
                location.href = refreshOptions[1];
            } else {
                location.reload();
            }
        });
    }
})();
