/**
 * Скрипт для получения локального конфига
 * Запускается командой "npm run get-config"
 * Результатом выполнения является вывод в консоль
 * переменных, которые нужно скопировать в свой ~/.bash_profile
 */

/* eslint no-console: "off" */

const { execSync } = require('child_process');
const _ = require('lodash');

const ENV_VAR_PREFIX = 'CONNECT_';
const SECRET_ID = 'ver-01f2kcmg3e6b6j6g2y3562qh6q';
const ERROR_MESSAGE = 'Не установлена утилита yandex-passport-vault-client или ' +
    'отсутствует доступ к секрету connect_local_config';
const INFO_MESSAGE = 'Добавьте экспорт переменных в ~/.bash_profile\n';

const COLORS_MAP = { red: 31, yellow: 33 };

const getVariableName = path => {
    if (path.startsWith('tokens.')) {
        const name = path.split('.')
            .map(namePart => _.snakeCase(namePart).toUpperCase())
            .join('__');

        return `${ENV_VAR_PREFIX}${name}`;
    }

    return path;
};

const getColoredMessage = (message, colorCode) => `\x1b[${colorCode}m${message}\x1b[0m`;

let secret;

try {
    secret = JSON.parse(execSync(`yav get version ${SECRET_ID} -j -O`).toString());
} catch (e) {
    console.log(getColoredMessage(ERROR_MESSAGE, COLORS_MAP.red));
    console.error(e);
}

console.log(getColoredMessage(INFO_MESSAGE, COLORS_MAP.yellow));
console.log('# =========================== START GET CONFIG ==========================\n');

Object.entries(secret).forEach(([key, value]) => {
    if (key.startsWith('robot-connect-test')) return;

    console.log(`export ${getVariableName(key)}=${value}`);
});

console.log('\n# ============================ END GET CONFIG ===========================\n');
