const fs = require('fs');
const path = require('path');

module.exports = filePaths => {
    if (typeof filePaths === 'string') {
        filePaths = [
            filePaths,
            path.join(__dirname, filePaths),
            path.join(process.cwd(), filePaths)
        ];
    }

    if (!Array.isArray(filePaths)) {
        return;
    }

    for (let i = 0; i < filePaths.length; i++) {
        if (fs.existsSync(filePaths[i])) {
            return filePaths[i];
        }
    }

    return filePath;
};
