const path = require('path');
const cli = require('../cli-util');

const app = cli.getArg('--app');

let config = cli.read([
    cli.getArg('--config'),
    path.join(process.cwd(), 'tanker.config.json'),
    path.join(process.cwd(), 'build.config.json'),
    path.join(process.cwd(), app || '', 'tanker.config.json'),
    path.join(process.cwd(), app || '', 'build.config.json')
], 'json');

if (app && config && config.apps && config.apps[app] && config.apps[app]) {
    config = config.apps[app].tanker;
}

module.exports = Object.assign(config || {}, { app });
