var rumBlockstatDict = null;

var blockstat = {
    subpage_name: 2924,
    id: 1701,
    time: 207,
    delta: 2877,
    subpage_index: 2925,
    'action.start_time': '689.2322',
    'tech.perf.time': '690.2096.207',
    'tech.perf.delta': '690.2096.2877',
};

function rumLoadDict(callback) {
    var dict = localStorage['rumBlockstat'];

    if (dict) {
        callback(JSON.parse(dict));
    } else {
        fetch('https://api.stat.yandex-team.ru/_api/dictionary/_blockstat/', {
            credentials: 'include',
        })
            .then(function(response) {
                return response.json();
            })
            .then(function(data) {
                rumSaveDict(data);

                callback(data);
            })
            .catch(function() {
                callback(null);
            });
    }
}

function rumSaveDict(dict) {
    localStorage['rumBlockstat'] = JSON.stringify(dict);
}

function rumDecode(name) {
    if (!rumBlockstatDict) {
        return name;
    }

    var res = [],
        parts = name.split('.'),
        part,
        bsName;

    for (var i = 0, l = parts.length; i < l; i++) {
        part = parts[i];
        bsName = rumBlockstatDict[part];

        if (part && part[0] === '-') {
            bsName = part;
        } else if (!bsName) {
            return name;
        }

        res.push(bsName);
    }

    return res.join('.');
}

rumLoadDict(function(dict) {
    rumBlockstatDict = dict;

    Ya.Rum.debug = function() {
        Ya.Rum.send = function(link, path, vars, clck, tree, sts, counterParams) {
            var varsToDecode = {
                    page: 1,
                    subpage_name: 1,
                    id: 1
                },
                varsArr = vars.split(','),
                varsPretty = {},
                logFields = function(fields) {
                    for (var name in fields) {
                        if (fields.hasOwnProperty(name)) {
                            console.log('%c' + name + '=' + fields[name], 'color: #c1470b;');
                        }
                    }
                };

            varsArr.forEach(function(pair) {
                var arr = pair.split('='),
                    name = arr[0],
                    value = arr[1];

                if (rumDecode(name) === 'ua') {
                    value = '(debug)...';
                }

                varsPretty[rumDecode(name)] = varsToDecode[rumDecode(name)]
                    ? rumDecode(value)
                    : value;
                varsPretty[name] = value;
            });

            var id = varsPretty.id || varsPretty[blockstat.id];

            console.group('%c' + rumDecode(path), 'color: #3333ee;');

            if (path === blockstat['tech.perf.time']) {
                var fields = {};

                if (varsPretty[blockstat.subpage_name]) {
                    fields[id] =
                        Math.floor(varsPretty[blockstat.time]) -
                        Math.floor(varsPretty[blockstat['action.start_time']]);

                    fields[id] +=
                        ' [' +
                        varsPretty[blockstat.subpage_name] +
                        '][' +
                        varsPretty[blockstat.subpage_index] +
                        ']';
                } else {
                    fields[id] = Math.floor(varsPretty[blockstat.time]);
                }

                logFields(fields);
            }

            if (path === blockstat['tech.perf.delta']) {
                var fields = {};
                fields[id] = varsPretty[blockstat.delta];

                if (varsPretty[blockstat.subpage_name]) {
                    fields[id] +=
                        ' [' +
                        varsPretty[blockstat.subpage_name] +
                        '][' +
                        varsPretty[blockstat.subpage_index] +
                        ']';
                }

                logFields(fields);
            }

            console.dir(varsPretty);

            if (counterParams) {
                console.log(counterParams);
            }

            console.groupEnd();
        };
    };

    Ya.Rum.debug();
});
