declare namespace Ya {
    namespace Rum {
        type AjaxPerfOptions = {
            /**
             * Время действия пользователя (клик или другое действие, приводящее к AJAX) –
             *    нужно для метрик ajax.before и ajax.total
             */
            actionTime?: number;

            /**
             * Специфичное время отправки запроса;
             *    если отсутствует за него принимается время создания объекта
             */
            requestSendTime?: number;

            /**
             * URL запроса, нужен для извлечения данных из Resource Timing API
             */
            url?: string;

            /**
             * XHR запроса, нужен для передачи статуса запроса в счётчике
             */
            xhr?: XMLHttpRequest;
        }

        /**
         * Счётчик скорости аякса
         * @constructor
         *
         * @param options Параметры объекта
         */
        class AjaxPerf {
            constructor(options?: AjaxPerfOptions);

            /**
             * Колбэк ошибки запроса
             */
            onRequestError(errorType: string | Error): void;

            /**
             * Колбэк окончания запроса
             */
            onRequestComplete(): void;

            /**
             * Колбэк окончания рендеринга результата
             */
            onRenderComplete(duration: number): void;

            /**
             * Отправить счётчик
             */
            send(): void;
        }
    }
}
