declare namespace Ya {
    namespace Rum {
        /**
         * Отправить счетчик с временной меткой.
         *
         * @param counterId - Код BlockStat. ID метки времени
         * @param time - Время. Если не передано, вычисляется время от начала навигации до момента вызова функции
         * @param addPerfMark - Добавлять метку в User Timing или нет, true по умолчанию
         * @param params - Кастомные параметры счетчика. Сюда же можно передать инстанс подстраницы
         */
        function sendTimeMark(
            counterId: string,
            time?: number,
            addPerfMark?: boolean,
            params?: { [ s: string ]: string; }
        ): void;

        /**
         * Получить отправленные на данный момент метки времени.
         */
        function getTimeMarks(): Record<string, number[]>;

        /**
         * Отмечает время окончания расчёта дельты и отправляет дельту.
         *
         * @param counterId - Код BlockStat. ID метки времени
         * @param vars - Объект с дополнительными переменными
         */
        function timeEnd(counterId: string, vars?: object): void;

        /**
         * Отправить счетчик с дельтой времени.
         *
         * @param counterId - Код BlockStat. ID метки времени
         * @param delta - Точное значение дельты
         * @param subPage - Инстанс подстраницы
         */
        function sendDelta(counterId: string, delta?: number, subPage?: any): void;

        /**
         * Отправить счётчик с временными метриками ресурса.
         *
         * @param counterId - Код BlockStat. ID метки времени
         * @param url
         */
        function sendResTiming(counterId: string | number, url: string): void;

        /**
         * Отправляет событие об отрисовке основного содержимого.
         *
         * @param time - время относительно жизненного цикла страницы
         */
        function sendHeroElement(time?: number): void;

        /**
         * Создает инстанс подстраницы, чтобы отправлять счетчики в отдельном неймспейсе.
         *
         * @param pageName - имя подстраницы
         * @param start - время создания
         */
        function makeSubPage(pageName: string, start?: (string | number)[]): void;
    }
}
