/**
 * @file
 * Отправка статистики загрузки ресурсов
 * Необходимо предварительно включить в код страницы Ya.Rum
 */
if (Ya.Rum.enabled) {
    addEventListener('load', function onload() {
        removeEventListener('load', onload);

        var rum = Ya.Rum;

        // 1724 – load. Время полной загрузки страницы
        rum.sendTimeMark('1724');

        // Счётчики загрузки скриптов и картинок
        if (!rum.getSetting('sendAutoResTiming')) {
            return;
        }

        var resources = document.querySelectorAll('script[data-rCid], div[data-rCid]');
        for (var i = 0, len = resources.length; i < len; i++) {
            var resource = resources[i],
                src = resource.src;

            // Если src не указан, то имеем дело с картинкой в background-image
            if (!src) {
                // background-image может быть задан через style, или через class.
                // Получаем через вычисление текущего стиля
                var bg = getComputedStyle(resource).backgroundImage;

                if (bg) {
                    // извлекаем URL из background-image,
                    // url('URL') -> URL
                    var url = bg.match(/^url\(["']?(.*?)["']?\)$/);

                    if (url) {
                        src = url[1];
                    }
                }
            }

            if (src) {
                rum.sendResTiming(resource.getAttribute('data-rCid'), src);
            }
        }
    });
}
