/*global Ya*/

/**
 * @file
 * Отправка статистики повторных обращений к API endpoints
 * Необходимо предварительно включить в код страницы Ya.Rum
 */
if (Ya.Rum.enabled) {
    /**
     * Отправить счётчик с информацией о перезапросах ресурса.
     *
     * @param {String} url
     * @param {Number} count - количество перезапросов
     */
    Ya.Rum.sendRetriesCount = function(url, count) {
        if (!url || !count || count < 1) {
            return;
        }

        var PATH_TECH_PERF_RETRIES = '690.2096.3037'; // tech.perf.retries
        var vars = Ya.Rum.getVarsList();

        vars.push(
            '13=' + encodeURIComponent(url),
            '1385=' + count
        );

        Ya.Rum.sendCounter(PATH_TECH_PERF_RETRIES, vars);
    };
}
