(function () {
/**
 * @file
 * Отправка запроса со счетчиками
 */
var MAX_BATCH_COUNTERS = 42; // определено в Кликдемоне
var COUNTERS_BATCH_TIMEOUT = 15; // интервал в миллисекундах, в течение которого счётчики склеиваются

var countersBatchData = [];
var counterTimerId;

/**
 * Отправка счётчика. Основной транспорт - sendBeacon, запасной - XMLHttpRequest. Быстро поступающие одиночные события
 * накапливаются и отправляются пачками по MAX_BATCH_COUNTERS штук.
 *
 * Количество и порядок параметров соответствует счётчику СЕРПа
 * window.wbt = function(link, path, vars, clck, tree, sts, counterParams)
 *
 * @param {*} link - не используется
 * @param {String} path
 * @param {String} vars
 * @param {*} clck - не используется
 * @param {*} tree - баобабные события https://wiki.yandex-team.ru/baobab/rfc/common/#sobytieclick
 * @param {*} sts - не используется
 * @param {Array} counterParams
 */
Ya.Rum.send = function(link, path, vars, clck, tree, sts, counterParams) {
    clearTimeout(counterTimerId);

    var slots = Ya.Rum.getSetting('slots');
    var experiments = Ya.Rum.getSetting('experiments');
    var counterSections = [
        // reqid добавляется на случай попадания в батч счётчиков из разных запросов – например, после аякса
        '/reqid=' + Ya.Rum.getSetting('reqid'),
        counterParams ? '/' + counterParams.join('/') : '',
        path ? '/path=' + path : '',
        tree ? '/events=' + tree : '',
        slots ? '/slots=' + slots.join(';') : '',
        experiments ? '/experiments=' + experiments.join(';') : '',
        vars ? '/vars=' + vars : '',
        '/cts=' + new Date().getTime(),
        '/*'
    ];

    countersBatchData.push(counterSections.join(''));

    if (countersBatchData.length < MAX_BATCH_COUNTERS) {
        counterTimerId = setTimeout(sendBatchRequest, COUNTERS_BATCH_TIMEOUT);
    } else {
        sendBatchRequest();
    }
};

function sendBatchRequest() {
    var clck = Ya.Rum.getSetting('clck'),
        data = countersBatchData.join('\r\n');

    countersBatchData = [];
    counterTimerId = null;

    if (!clck) {
        return;
    }

    var sendBeaconPostAvailable = navigator.sendBeacon && Ya.Rum.getSetting('beacon'),
        sendBeaconResult = sendBeaconPostAvailable && navigator.sendBeacon(clck, data);

    if (!sendBeaconResult) {
        var xhr = new XMLHttpRequest();
        xhr.open('POST', clck);
        xhr.send(data);
    }
}

}());
