declare namespace Ya {
    namespace Rum {
        /**
         * Определяет момент времени от начала навигации, когда была отрисована DOM-нода.
         * Если вместо ссылки на DOM-ноду передана строка селектора, то время будет определено с точностью до 100мс
         * (интервал проверок на появление элемента в DOM).
         *
         * @param counterID - Код BlockStat. ID метки времени
         * @param target - DOM-нода, за видимостью которой надо смотреть
         *     ИЛИ CSS-селектор для получения ноды
         * @param ioOptions - Опции для IntersectionObserver
         */
        function observeDOMNode(
            counterID: string | number,
            target: HTMLElement | string,
            ioOptions?: IntersectionObserverInit,
        ): void;
    }
}
