/**
 * @file
 * Функция для определения момента времени, когда была отрисована DOM-нода
 * @depends interface.js
 */

/**
 * Определяет момент времени от начала навигации, когда была отрисована DOM-нода.
 * Если вместо ссылки на DOM-ноду передана строка селектора, то время будет определено с точностью до 100мс
 * (интервал проверок на появление элемента в DOM).
 *
 * @param {String|Number} counterID - Код BlockStat. ID метки времени
 * @param {HTMLElement|String} target - DOM-нода, за видимостью которой надо смотреть
 *     ИЛИ CSS-селектор для получения ноды
 * @param {Object} [ioOptions] - Опции для IntersectionObserver
 */
Ya.Rum.observeDOMNode = window.IntersectionObserver ? function(counterID, target, ioOptions) {
    var that = this,
        forcePaintTimeSending = Ya.Rum.getSetting('forcePaintTimeSending');

    function check() {
        if (!forcePaintTimeSending && that.isVisibilityChanged()) {
            return;
        }

        var domNode = (typeof target === 'string') ?
            document.querySelector(target) :
            target;

        if (domNode) {
            (new IntersectionObserver(function(entries, observer) {
                if (!forcePaintTimeSending && that.isVisibilityChanged()) {
                    return;
                }

                Ya.Rum.sendTimeMark(counterID);
                observer.unobserve(domNode);
            }, ioOptions)).observe(domNode);
        } else {
            setTimeout(check, 100);
        }
    }

    check();
} : function() {
    // заглушка
};
