(function () {
/**
 * @file
 * Сохраняет времена блокировки основного потока js
 * https://github.com/GoogleChrome/tti-polyfill
 * this snippet is a temporary workaround, until browsers implement level 2 of the Performance Observer spec and include the buffered flag.
 */
if (window.PerformanceLongTaskTiming) {
    var MAX_EVENTS_COUNT = 300,
        addEvents = function(events, entries) {
            events = events.concat(entries);
            if (events.length > MAX_EVENTS_COUNT) {
                events = events.slice(events.length - MAX_EVENTS_COUNT);
            }
            return events;
        },
        inst = Ya.Rum._tti = {
            /**
             * Массив последних событий longtask, количество ограничено числом MAX_EVENTS_COUNT
             */
            events: [],
            eventsAfterTTI: [],
            fired: false,

            observer: new PerformanceObserver(function(tasks) {
                var entries = tasks.getEntries();

                inst.events = addEvents(inst.events, entries);

                if (inst.fired) {
                    inst.eventsAfterTTI = addEvents(inst.eventsAfterTTI, entries);
                }
            })
        };

    inst.observer.observe({
        entryTypes: ['longtask']
    });
}

}());
