const visit = require('unist-util-visit');
const transliterate = require('./transliterate');

function transformer(ast) {
    function visitor(header) {
        if (header.anchor) {
            return header.anchor = transliterate(header.anchor);
        }

        header.text = '';
        visit(header, 'text', function(textNode) {
            header.text += textNode.value;
        });

        header.anchor = transliterate(header.text);
    }

    visit(ast, 'heading', visitor);
    visit(ast, 'womHeading', visitor);
}

function slug() {
    return transformer;
}

module.exports = slug;
