module.exports = function(transform, node) {
    const props = {
        'wiki-attrs': {
            nomark: true,
        },
        mods: {
            format: 'code',
            type: 'block',
        },
        lang: node.lang || 'no-highlight',
        multiline: true,
        linesCount: node.value.trim().split('\n').length,
    };

    return transform(node, 'wiki-formatter', props, node.value);
};
