const parseBlock = require('mdast-util-to-bemjson/lib/build-node').parse;

const defaultTypesMap = {
    paragraph: 'wiki-p',
    emphasis: 'wiki-italic',
    strong: 'wiki-bold',
    delete: 'wiki-strike',
    thematicBreak: 'wiki-hr',
    blockquote: 'wiki-bquot',
    table: 'wiki-table',
    tableRow: 'wiki-row',
    tableCell: 'wiki-cell',
    womTable: 'wiki-table',
    womTableRow: 'wiki-row',
    womTableCell: 'wiki-cell',
    womBlockquote: 'wiki-bquot',
    womBreak: 'wiki-br',
    break: 'wiki-br',
};

module.exports = function(transform, node) {
    const type = defaultTypesMap[node.type] || `wiki-${node.type.replace('wom', '')}`;
    const block = parseBlock(type);

    const props = Object.assign({}, node);
    delete props.type;
    delete props.value;
    delete props.children;
    delete props.position;

    return transform(node, block, props, node.value);
};
