const traverse = require('mdast-util-to-bemjson/lib/traverse');

module.exports = function(transform, node) {
    const content = traverse.children(transform, node);
    const footnote = {
        block: 'wiki-footnote',
        'wiki-attrs': {
            kind: 'note',
            type: 'named',
            name: node.identifier,
            label: node.identifier + ': ',
        },
    };

    if (Array.isArray(content.content)) {
        content.content.unshift(footnote);
    } else {
        content.content = [footnote, content.content];
    }

    return content;
};
