const revert = require('../revert');

module.exports = function(transform, node) {
    const definition = transform.definition(node.identifier);

    if (!definition) {
        return revert(transform, node);
    }

    const props = {
        alt: node.alt,
        title: definition.title,
        url: definition.url,
    };

    return transform(node, 'wiki-img', props);
};
