const traverse = require('mdast-util-to-bemjson/lib/traverse');

module.exports = function(transform, node) {
    const props = {
        'wiki-attrs': {
            loose: node.loose,
            checked: node.checked,
            value: node.restart,
        },
    };

    let content;
    if (node.expandable) {
        content = traverse(transform, {
            type: 'womCut',
            title: node.title,
            children: node.children,
        }, node);
    }

    return transform(node, 'wiki-li', props, content);
};
