const visit = require('unist-util-visit');
const isHeading = node => (node.type === 'womHeading' || node.type === 'heading');
const isInclude = node => (node.type === 'womAction' && node.name === 'include');
const isAnchor = node => (node.type === 'womAction' && (node.name === 'a' || node.name === 'anchor'));

module.exports = function(settings) {
    return function(transform, node) {
        const toc = [];
        const anchors = {};

        function tocVisitor(node) {
            if (isHeading(node)) {
                let value = '';
                visit(node, 'text', function(textNode) {
                    value += textNode.value;
                });

                toc.push({
                    type: 'heading',
                    depth: node.depth,
                    anchor: node.anchor,
                    value,
                    isMd: node.type === 'heading',
                });
            } else {
                toc.push({
                    type: 'include',
                    page: node.params.page,
                });
            }
        }
        visit(node, function(node) {
            return isHeading(node) || isInclude(node);
        }, tocVisitor);

        function anchorVisitor(node) {
            const name = node.params && (node.params.href || node.params.name);

            if (!name) {
                return;
            }

            anchors[name] = {
                start: node.position.start.offset,
                end: node.position.end.offset,
            };
        }
        visit(node, function(node) {
            return isAnchor(node);
        }, anchorVisitor);

        // Удаляю из настроек особые внутренние значения,
        // прежде чем это все попадет в атрибуты
        const {
            parseWikiMd: _parseWikiMd,
            formatMdAst: _formatMdAst,
            fetchAction: _fetchAction,
            promises: _promises,
            ...cleanSettings
        } = settings;

        const props = {
            'wiki-attrs': cleanSettings,
            mods: {
                magiclinks: 'yes',
            },
            toc,
            anchors,
        };
        return transform(node, 'wiki-doc', props);
    };
};
