module.exports = function(transform, node) {
    let type; let number; let name;
    const id = node.identifier;

    if (/^\*+$/.test(id)) {
        type = 'asterisk';
        number = id.length;
    } else if (/^\d+$/.test(id)) {
        type = 'numeric';
        number = Number(id);
    } else {
        type = 'named';
        name = id;
    }
    const props = {
        'wiki-attrs': {
            kind: 'note',
            type,
            name,
            number,
            label: node.label,
        },
    };

    return transform(node, 'wiki-footnote', props);
};
