const formats = {
    math: 'math',
    comments: 'comments',
    comment: 'comments',
    csv: 'csv',
    plantuml: 'plantuml',
    graphviz: 'graph',
    blockdiag: 'graph',
    seqdiag: 'graph',
};

module.exports = function(transform, node) {
    const wikiAttrs = {};
    for (let attr in node.attributes) {
        wikiAttrs[attr.replace(/^wrapper_/, '')] = node.attributes[attr];
    }

    const props = {
        'wiki-attrs': wikiAttrs,
        mods: {
            format: node.format && formats[node.format] || 'code',
        },
    };

    props.baseFormat = node.format;

    if (node.inline) {
        props.mods.type = 'inline';
    }

    if (props.mods.format === 'code') {
        props.lang = node.format;
        if (!props.lang || node.attributes.hasOwnProperty('nohighlight')) {
            props.lang = 'no-highlight';
        }

        let lineCount = 1;
        const subValue = node.value.trim();
        const length = subValue.length;

        for (let i = 0; i < length; i++) {
            if (subValue.charAt(i) === '\n') {
                lineCount++;
            }
        }

        props.multiline = lineCount > 1;
        props.linesCount = lineCount;
    }

    return transform(node, 'wiki-formatter', props, node.value);
};
